#! /bin/bash
# Script to build LPC55Sxx Master Boot Image using nxpimage tool

# Environment variables - absolute paths simplifying re-use of the script on another machine
#  - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
if [ -z "${SPT_WORKSPACE}" ]; then
  export "SPT_WORKSPACE=$(cd "$(dirname "$0")"; pwd -P)"
fi
if ! [ -d "$SPT_WORKSPACE" ]; then
  echo "FAILURE: Directory not found: $SPT_WORKSPACE"
  exit 2
fi
#  - Absolute path to SPT installation directory
if [ -z "${SPT_INSTALL_BIN}" ]; then
  export "SPT_INSTALL_BIN=C:/nxp/MCUX_Provi_v8/bin"
fi
if ! [ -d "$SPT_INSTALL_BIN" ]; then
  echo "FAILURE: Directory not found: $SPT_INSTALL_BIN"
  exit 2
fi

# Used command line utilities
export "nxpimage=${SPT_INSTALL_BIN}/tools_scripts/nxpimage_spsdk_lnx_wrapper.sh"
export "pfr=${SPT_INSTALL_BIN}/tools/spsdk/pfr"

mkdir -p "${SPT_WORKSPACE}/bootable_images"
if [ $? -ge 1 ]; then
    exit 2
fi

echo '### Create bootable image ###'
"$nxpimage" mbi export -c "${SPT_WORKSPACE}/configs/mbi_config.json"
if [ $? -ge 2 ]; then
    exit 2
fi

echo "### Create CFPA page (binary) ###"
echo "$pfr generate-binary -c \"${SPT_WORKSPACE}/configs/cfpa.json\" -o \"${SPT_WORKSPACE}/configs/cfpa.bin\""
pushd "$SPT_WORKSPACE"
"$pfr" generate-binary -c "${SPT_WORKSPACE}/configs/cfpa.json" \
		-o "${SPT_WORKSPACE}/configs/cfpa.bin"
if [ $? -ge 1 ]; then
    popd
    exit 2
fi
popd

echo "### Create CMPA page (binary) ###"
pushd "$SPT_WORKSPACE"
echo "%pfr% generate-binary -c ${SPT_WORKSPACE}/configs/cmpa.json -o ${SPT_WORKSPACE}/configs/cmpa.bin"
"$pfr" generate-binary -c "${SPT_WORKSPACE}/configs/cmpa.json" \
        -o "${SPT_WORKSPACE}/configs/cmpa.bin"
if [ $? -ge 1 ]; then
    popd
    exit 2
fi
popd